/*
 * Decompiled with CFR 0.152.
 */
package com.byteslooser.filters.artifacts;

import com.byteslooser.filters.artifacts.ITableModelFilter;
import com.byteslooser.filters.artifacts.RowFilter;
import java.util.Arrays;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class TableModelFilter
extends AbstractTableModel
implements ITableModelFilter {
    private int[] rowsMapper = new int[0];
    private int validRows = 0;
    private int[] viewsMapper = new int[0];
    private boolean viewMap;
    private TableModelListener tableModelListener = new TableListener();
    private RowFilterEntry rowFilterEntry = new RowFilterEntry();
    RowFilter tableFilter;
    TableModel tableModel;

    public TableModelFilter(TableModel model) {
        this.setModel(model);
    }

    public void setModel(TableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.handleModifiedModel();
        this.fireTableStructureChanged();
    }

    void handleModifiedModel() {
        this.rowFilterEntry.columns = this.tableModel.getColumnCount();
        this.reapplyFilter();
    }

    @Override
    public TableModel getModel() {
        return this.tableModel;
    }

    @Override
    public void setRowFilter(RowFilter newValue) {
        this.tableFilter = newValue;
        this.reapplyFilter();
        this.fireTableDataChanged();
    }

    public int convertRowIndexToModel(int index) {
        return this.rowsMapper[index];
    }

    public int convertModelIndexToRow(int index) {
        for (int i = 0; i < this.rowsMapper.length; ++i) {
            if (this.rowsMapper[i] != index) continue;
            return i;
        }
        return -1;
    }

    public int convertRowIndexToView(int index) {
        if (!this.viewMap) {
            this.viewMap = true;
            this.viewsMapper = this.resizeArray(this.viewsMapper, this.tableModel.getRowCount());
            for (int i = 0; i < this.validRows; ++i) {
                this.viewsMapper[this.rowsMapper[i]] = i;
            }
        }
        return this.viewsMapper[index];
    }

    private int[] resizeArray(int[] original, int size) {
        int[] ret = original.length >= size && original.length <= size / 4 * 5 ? original : new int[size];
        Arrays.fill(ret, -1);
        return ret;
    }

    void reapplyFilter() {
        this.viewMap = false;
        int rows = this.tableModel.getRowCount();
        this.rowsMapper = this.resizeArray(this.rowsMapper, rows);
        this.validRows = 0;
        for (int j = 0; j < rows; ++j) {
            this.rowFilterEntry.modelRow = j;
            if (this.tableFilter != null && !this.tableFilter.include(this.rowFilterEntry)) continue;
            this.rowsMapper[this.validRows++] = j;
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.tableModel.getColumnClass(columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    @Override
    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.validRows;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.tableModel.getValueAt(this.convertRowIndexToModel(rowIndex), columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.tableModel.isCellEditable(this.convertRowIndexToModel(rowIndex), columnIndex);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.tableModel.setValueAt(value, this.convertRowIndexToModel(rowIndex), columnIndex);
    }

    class TableListener
    implements TableModelListener {
        TableListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (TableModelFilter.this.tableFilter == null) {
                TableModelFilter.this.fireTableChanged(e);
            } else if (e.getFirstRow() == -1) {
                TableModelFilter.this.handleModifiedModel();
                TableModelFilter.this.fireTableChanged(e);
            } else if (e.getType() == 0 && e.getLastRow() != Integer.MAX_VALUE) {
                TableModelFilter.this.fireTableChanged(e);
            } else {
                TableModelFilter.this.reapplyFilter();
                TableModelFilter.this.fireTableDataChanged();
            }
        }
    }

    class RowFilterEntry
    extends RowFilter.Entry {
        int columns;
        int modelRow;

        RowFilterEntry() {
        }

        @Override
        public Object getValue(int index) {
            return TableModelFilter.this.tableModel.getValueAt(this.modelRow, index);
        }
    }
}

