/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import gnu.io.NRSerialPortException;
import gnu.io.NativeResourceException;
import gnu.io.PortInUseException;
import gnu.io.RXTXCommDriver;
import gnu.io.RXTXPort;
import gnu.io.SerialPortEventListener;
import gnu.io.factory.RxTxPortCreator;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TooManyListenersException;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class NRSerialPort<J extends NRSerialPort<J>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private transient RXTXPort serial;
    private String port = null;
    private boolean connected = false;
    private int baud = 115200;

    public NRSerialPort() {
    }

    public NRSerialPort(String port, int baud) {
        this.setPort(port);
        this.setBaud(baud);
    }

    public boolean connect() {
        if (this.isConnected()) {
            System.err.println(this.port + " is already connected.");
            return true;
        }
        try {
            this.serial = new RxTxPortCreator().createPort(this.port);
            this.serial.setSerialPortParams(this.getBaud(), 8, 1, 0);
            this.setConnected(true);
        }
        catch (NativeResourceException e) {
            this.setConnected(false);
            throw new NRSerialPortException("No Port", e);
        }
        catch (PortInUseException e) {
            this.setConnected(false);
            throw new NRSerialPortException("Port in Use", e);
        }
        catch (Exception e) {
            this.setConnected(false);
            throw new NRSerialPortException("General Exception - " + e.getMessage(), e);
        }
        if (this.isConnected()) {
            this.serial.notifyOnDataAvailable(true);
        }
        return this.isConnected();
    }

    @JsonIgnore
    public InputStream getInputStream() {
        return this.serial.getInputStream();
    }

    @JsonIgnore
    public OutputStream getOutputStream() {
        return this.serial.getOutputStream();
    }

    private void setPort(String port) {
        this.port = port;
    }

    public J disconnect() {
        if (!this.connected) {
            return (J)this;
        }
        try {
            try {
                this.getInputStream().close();
                this.getOutputStream().close();
                this.serial.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            this.serial = null;
            this.setConnected(false);
        }
        catch (UnsatisfiedLinkError e) {
            throw new NativeResourceException(e.getMessage());
        }
        return (J)this;
    }

    public static Set<String> getAvailableSerialPorts() {
        HashSet<String> available = new HashSet<String>();
        try {
            RXTXCommDriver d = new RXTXCommDriver();
            Set<String> av = d.getPortIdentifiers();
            ArrayList<String> strs = new ArrayList<String>();
            for (String s : av) {
                strs.add(0, s);
            }
            for (String s : strs) {
                available.add(s);
            }
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            throw new NativeResourceException(e.getMessage());
        }
        return available;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public J setConnected(boolean connected) {
        if (this.connected == connected) {
            return (J)this;
        }
        this.connected = connected;
        return (J)this;
    }

    public J setBaud(int baud) {
        this.baud = baud;
        return (J)this;
    }

    public int getBaud() {
        return this.baud;
    }

    public int enableRs485(boolean busEnableActiveLow, int delayBusEnableBeforeSendMs, int delayBusEnableAfterSendMs) {
        if (this.serial == null) {
            return -1;
        }
        return this.serial.enableRs485(busEnableActiveLow, delayBusEnableBeforeSendMs, delayBusEnableAfterSendMs);
    }

    public void notifyOnDataAvailable(boolean b) {
        this.serial.notifyOnDataAvailable(b);
    }

    public void addEventListener(SerialPortEventListener lsnr) throws TooManyListenersException {
        this.serial.addEventListener(lsnr);
    }

    public void removeEventListener() {
        this.serial.removeEventListener();
    }

    @JsonIgnore
    public RXTXPort getSerialPortInstance() {
        return this.serial;
    }
}

