/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.AudioUtils;
import org.tritonus.share.sampled.FloatSampleBuffer;
import org.tritonus.share.sampled.FloatSampleInput;
import org.tritonus.share.sampled.convert.TSimpleFormatConversionProvider;

public class SampleRateConversionProvider
extends TSimpleFormatConversionProvider {
    public static AudioFormat.Encoding PCM_SIGNED = AudioFormat.Encoding.PCM_SIGNED;
    public static AudioFormat.Encoding PCM_UNSIGNED = AudioFormat.Encoding.PCM_UNSIGNED;
    private static final boolean DEBUG_STREAM = false;
    private static final boolean DEBUG_STREAM_PROBLEMS = false;
    private static final int ALL = -1;
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 24, -1, -1, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 24, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 32, -1, -1, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 32, -1, -1, -1.0f, true)};
    private static final float[] commonSampleRates = new float[]{8000.0f, 11025.0f, 12000.0f, 16000.0f, 22050.0f, 24000.0f, 32000.0f, 44100.0f, 48000.0f, 56000.0f, 64000.0f, 88200.0f, 96000.0f, 192000.0f};

    public SampleRateConversionProvider() {
        super(Arrays.asList(OUTPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS));
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        AudioFormat sourceFormat = sourceStream.getFormat();
        if (AudioFormats.matches(sourceFormat, targetFormat)) {
            return sourceStream;
        }
        if ((targetFormat = this.replaceNotSpecified(sourceFormat, targetFormat)).getSampleRate() != -1.0f && sourceFormat.getSampleRate() != -1.0f && targetFormat.getChannels() != -1 && sourceFormat.getChannels() != -1 && targetFormat.getSampleSizeInBits() != -1 && sourceFormat.getSampleSizeInBits() != -1 && this.isConversionSupported(targetFormat, sourceFormat)) {
            return new SampleRateConverterStream(sourceStream, targetFormat);
        }
        throw new IllegalArgumentException("format conversion not supported");
    }

    private static AudioFormat replaceSampleRate(AudioFormat format, float newSampleRate) {
        if (format.getSampleRate() == newSampleRate) {
            return format;
        }
        return new AudioFormat(format.getEncoding(), newSampleRate, format.getSampleSizeInBits(), format.getChannels(), format.getFrameSize(), newSampleRate, format.isBigEndian());
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">SampleRateConversionProvider.getTargetFormats(AudioFormat.Encoding, AudioFormat):");
            TDebug.out("checking out possible target formats");
            TDebug.out("from: " + sourceFormat);
            TDebug.out("to  : " + targetEncoding);
        }
        float sourceSampleRate = sourceFormat.getSampleRate();
        if (this.isConversionSupported(targetEncoding, sourceFormat = SampleRateConversionProvider.replaceSampleRate(sourceFormat, -1.0f))) {
            ArraySet<AudioFormat> result = new ArraySet<AudioFormat>();
            for (AudioFormat targetFormat : this.getCollectionTargetFormats()) {
                if (!this.isConversionSupported(targetFormat = this.replaceNotSpecified(sourceFormat, targetFormat), sourceFormat)) continue;
                result.add(targetFormat);
            }
            if (result.size() > 0 && sourceSampleRate != -1.0f) {
                int count = result.size();
                for (int i = 0; i < count; ++i) {
                    AudioFormat format = (AudioFormat)result.get(i);
                    for (int j = 0; j < commonSampleRates.length; ++j) {
                        if (SampleRateConversionProvider.doMatch(sourceSampleRate, commonSampleRates[j])) continue;
                        result.add(SampleRateConversionProvider.replaceSampleRate(format, commonSampleRates[j]));
                    }
                }
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("<found " + result.size() + " matching formats.");
            }
            return result.toArray(EMPTY_FORMAT_ARRAY);
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<returning empty array.");
        }
        return EMPTY_FORMAT_ARRAY;
    }

    public boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        boolean result;
        boolean bl = result = (targetFormat.getSampleRate() == -1.0f || targetFormat.getSampleRate() == -1.0f || !SampleRateConversionProvider.doMatch(targetFormat.getSampleRate(), sourceFormat.getSampleRate()) && SampleRateConversionProvider.doMatch(targetFormat.getChannels(), sourceFormat.getChannels())) && AudioUtils.containsFormat(sourceFormat, this.getCollectionSourceFormats().iterator()) && AudioUtils.containsFormat(targetFormat, this.getCollectionTargetFormats().iterator());
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">SampleRateConverter: isConversionSupported(AudioFormat, AudioFormat):");
            TDebug.out("checking if conversion possible");
            TDebug.out("from: " + sourceFormat);
            TDebug.out("to  : " + targetFormat);
            TDebug.out("< result : " + result);
        }
        return result;
    }

    protected static long convertLength(AudioFormat sourceFormat, AudioFormat targetFormat, long sourceLength) {
        if (sourceLength == -1L) {
            return sourceLength;
        }
        return (long)(targetFormat.getSampleRate() / sourceFormat.getSampleRate() * (float)sourceLength);
    }

    protected static long convertLength(float sourceSR, float targetSR, long sourceLength) {
        if (sourceLength == -1L) {
            return sourceLength;
        }
        return (long)(targetSR / sourceSR * (float)sourceLength);
    }

    public static class SRCAudioFormat
    extends AudioFormat {
        private float sampleRate;

        public SRCAudioFormat(AudioFormat targetFormat) {
            super(targetFormat.getEncoding(), targetFormat.getSampleRate(), targetFormat.getSampleSizeInBits(), targetFormat.getChannels(), AudioUtils.getFrameSize(targetFormat.getChannels(), targetFormat.getSampleSizeInBits()), targetFormat.getSampleRate(), targetFormat.isBigEndian(), targetFormat.properties());
            this.sampleRate = targetFormat.getSampleRate();
        }

        public void setSampleRate(float sr) {
            if (sr > 0.0f) {
                this.sampleRate = sr;
            }
        }

        public float getSampleRate() {
            return this.sampleRate;
        }

        public float getFrameRate() {
            return this.sampleRate;
        }
    }

    public static class SampleRateConverterStream
    extends AudioInputStream
    implements FloatSampleInput {
        private FloatSampleBuffer thisBuffer = null;
        private FloatSampleBuffer writeBuffer = null;
        private byte[] byteBuffer;
        private AudioInputStream sourceStream;
        private FloatSampleInput sourceInput;
        private float sourceSampleRate;
        private float targetSampleRate;
        private long sourceFrameLength;
        private double dPos;
        public static final int SAMPLE_AND_HOLD = 1;
        public static final int LINEAR_INTERPOLATION = 2;
        public static final int RESAMPLE = 3;
        private boolean eofReached = false;
        private int sourceBufferTime;
        private int sourceBufferSizeSamples;
        private int conversionAlgorithm = 2;
        private FloatSampleBuffer historyBuffer = null;
        private int minimumSamplesInHistory = 1;
        private boolean thisBufferValid = false;
        private long testInFramesRead = 0L;
        private long testOutFramesReturned = 0L;

        public SampleRateConverterStream(AudioInputStream sourceStream, AudioFormat targetFormat) {
            super(sourceStream, new SRCAudioFormat(targetFormat), SampleRateConversionProvider.convertLength(sourceStream.getFormat(), targetFormat, sourceStream.getFrameLength()));
            if (TDebug.TraceAudioConverter) {
                TDebug.out("SampleRateConverterStream: <init>");
            }
            this.sourceStream = sourceStream;
            this.sourceInput = sourceStream instanceof FloatSampleInput ? (FloatSampleInput)((Object)sourceStream) : null;
            this.sourceSampleRate = sourceStream.getFormat().getSampleRate();
            this.targetSampleRate = targetFormat.getSampleRate();
            this.sourceFrameLength = sourceStream.getFrameLength();
            this.dPos = 0.0;
            this.sourceBufferTime = 100;
            this.resizeBuffers();
            this.flush();
        }

        public SampleRateConverterStream(FloatSampleInput sourceInput, AudioFormat targetFormat, long frameLength) {
            super(new ByteArrayInputStream(new byte[0]), new SRCAudioFormat(targetFormat), SampleRateConversionProvider.convertLength(sourceInput.getSampleRate(), targetFormat.getSampleRate(), frameLength));
            if (TDebug.TraceAudioConverter) {
                TDebug.out("SampleRateConverterStream: <init>");
            }
            this.sourceStream = null;
            this.sourceInput = sourceInput;
            this.sourceSampleRate = sourceInput.getSampleRate();
            this.targetSampleRate = targetFormat.getSampleRate();
            this.sourceFrameLength = frameLength;
            this.dPos = 0.0;
            this.sourceBufferTime = 100;
            this.resizeBuffers();
            this.flush();
        }

        private synchronized void resizeBuffers() {
            this.sourceBufferSizeSamples = (int)AudioUtils.millis2Frames((long)this.sourceBufferTime, (double)this.sourceSampleRate);
            if (this.sourceBufferSizeSamples < this.minimumSamplesInHistory) {
                this.sourceBufferSizeSamples = this.minimumSamplesInHistory;
            }
            if ((double)this.sourceBufferSizeSamples < this.outSamples2inSamples(1.0)) {
                this.sourceBufferSizeSamples = (int)this.outSamples2inSamples(1.0) + 1;
            }
            if (this.historyBuffer == null) {
                this.historyBuffer = new FloatSampleBuffer(this.getFormat().getChannels(), this.sourceBufferSizeSamples, this.sourceSampleRate);
                this.historyBuffer.makeSilence();
            }
            this.historyBuffer.changeSampleCount(this.sourceBufferSizeSamples, true);
            if (this.thisBuffer == null) {
                this.thisBuffer = new FloatSampleBuffer(this.getFormat().getChannels(), this.sourceBufferSizeSamples, this.sourceSampleRate);
            }
            this.thisBuffer.changeSampleCount(this.sourceBufferSizeSamples, true);
            if (TDebug.TraceAudioConverter) {
                // empty if block
            }
        }

        private void beforeReadFromSourceStream() {
            FloatSampleBuffer lBuffer = this.thisBuffer;
            if (lBuffer != null && lBuffer.getSampleCount() != this.sourceBufferSizeSamples) {
                lBuffer.changeSampleCount(this.sourceBufferSizeSamples, false);
            }
        }

        private void readFromByteSourceStream() {
            int thisRead;
            int byteCount = this.thisBuffer.getByteArrayBufferSize(this.sourceStream.getFormat());
            if (this.byteBuffer == null || this.byteBuffer.length < byteCount) {
                this.byteBuffer = new byte[byteCount];
            }
            if (TDebug.TraceAudioConverter) {
                // empty if block
            }
            int bytesRead = 0;
            do {
                try {
                    thisRead = this.sourceStream.read(this.byteBuffer, bytesRead, byteCount - bytesRead);
                }
                catch (IOException ioe) {
                    thisRead = -1;
                }
                if (thisRead <= 0) continue;
                bytesRead += thisRead;
            } while (bytesRead < byteCount && thisRead > 0);
            if (bytesRead == 0) {
                this.close();
            } else {
                this.thisBuffer.initFromByteArray(this.byteBuffer, 0, bytesRead, this.sourceStream.getFormat());
                if (TDebug.TraceAudioConverter) {
                    // empty if block
                }
            }
        }

        private void readFromSourceInput() {
            if (this.sourceInput.isDone()) {
                this.close();
            } else {
                this.sourceInput.read(this.thisBuffer);
            }
        }

        private void readFromSourceStream() {
            if (this.isClosed()) {
                return;
            }
            FloatSampleBuffer lBuffer = this.historyBuffer;
            this.historyBuffer = this.thisBuffer;
            this.thisBuffer = lBuffer;
            this.beforeReadFromSourceStream();
            int oldSampleCount = this.thisBuffer.getSampleCount();
            if (this.sourceFrameLength != -1L && (long)lBuffer.getSampleCount() + this.testInFramesRead > this.sourceFrameLength) {
                long remaining = this.sourceFrameLength - this.testInFramesRead;
                if (remaining <= 0L) {
                    if (TDebug.TraceAudioConverter) {
                        // empty if block
                    }
                    this.close();
                    return;
                }
                if (TDebug.TraceAudioConverter) {
                    // empty if block
                }
                lBuffer.changeSampleCount((int)remaining, false);
            }
            if (this.sourceInput != null) {
                this.readFromSourceInput();
            } else {
                this.readFromByteSourceStream();
            }
            int sampleCount = lBuffer == null ? 0 : lBuffer.getSampleCount();
            this.testInFramesRead += (long)sampleCount;
            if (TDebug.TraceAudioConverter) {
                // empty if block
            }
            double inc = this.outSamples2inSamples(1.0);
            if (!this.thisBufferValid) {
                this.thisBufferValid = true;
                this.dPos = 0.0;
            } else {
                double temp = this.dPos;
                this.dPos -= (double)oldSampleCount;
                if ((this.dPos > inc || this.dPos < -inc) && (int)this.dPos != 0) {
                    this.dPos = 0.0;
                }
            }
        }

        protected void convertSampleAndHold1(float[] inSamples, double inSampleOffset, int inSampleCount, double increment, float[] outSamples, int outSampleOffset, int outSampleCount, float[] history, int historyLength) {
            for (int i = 0; i < outSampleCount; ++i) {
                int iInIndex = (int)(inSampleOffset + increment * (double)i);
                if (iInIndex < 0) {
                    outSamples[i + outSampleOffset] = history[iInIndex + historyLength];
                    continue;
                }
                if (iInIndex >= inSampleCount) continue;
                outSamples[i + outSampleOffset] = inSamples[iInIndex];
            }
        }

        private void convertSampleAndHold2(float[] inSamples, double inSampleOffset, int inSampleCount, double increment, float[] outSamples, int outSampleOffset, int outSampleCount, float[] history, int historyLength) {
            int endSampleOffset = outSampleOffset + outSampleCount;
            double dHistoryLength = historyLength;
            while (inSampleOffset < 0.0 && outSampleOffset < endSampleOffset) {
                double dInIndex = inSampleOffset + dHistoryLength;
                outSamples[outSampleOffset] = history[(int)dInIndex];
                inSampleOffset += increment;
                ++outSampleOffset;
            }
            while (outSampleOffset < endSampleOffset) {
                outSamples[outSampleOffset] = inSamples[(int)inSampleOffset];
                inSampleOffset += increment;
                ++outSampleOffset;
            }
        }

        protected void convertLinearInterpolation1(float[] inSamples, double inSampleOffset, int inSampleCount, double increment, float[] outSamples, int outSampleOffset, int outSampleCount, float[] history, int historyLength) {
            for (int i = 0; i < outSampleCount; ++i) {
                try {
                    double dInIndex = inSampleOffset + increment * (double)i - 1.0;
                    int iInIndex = (int)Math.floor(dInIndex);
                    double factor = 1.0 - (dInIndex - (double)iInIndex);
                    float value = 0.0f;
                    for (int x = 0; x < 2; ++x) {
                        if (iInIndex < inSampleCount) {
                            if (iInIndex < 0) {
                                int histIndex = iInIndex + historyLength;
                                if (histIndex >= 0) {
                                    value = (float)((double)value + (double)history[histIndex] * factor);
                                }
                            } else {
                                value = (float)((double)value + (double)inSamples[iInIndex] * factor);
                            }
                        }
                        factor = 1.0 - factor;
                        ++iInIndex;
                    }
                    outSamples[i + outSampleOffset] = value;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }

        private void convertLinearInterpolation2(float[] inSamples, double inSampleOffset, int inSampleCount, double increment, float[] outSamples, int outSampleOffset, int outSampleCount, float[] history, int historyLength) {
            block6: {
                try {
                    int endSampleOffset = outSampleOffset + outSampleCount;
                    double dHistoryLength = historyLength;
                    while (inSampleOffset < 0.0 && outSampleOffset < endSampleOffset) {
                        double dInIndex = inSampleOffset + dHistoryLength;
                        int histIndex = (int)dInIndex;
                        float factor = (float)(dInIndex - (double)histIndex);
                        outSamples[outSampleOffset] = history[histIndex - 1] * (1.0f - factor) + history[histIndex] * factor;
                        inSampleOffset += increment;
                        ++outSampleOffset;
                    }
                    while (inSampleOffset < 1.0 && outSampleOffset < endSampleOffset) {
                        float factor = (float)inSampleOffset;
                        outSamples[outSampleOffset] = history[historyLength - 1] * (1.0f - factor) + inSamples[0] * factor;
                        inSampleOffset += increment;
                        ++outSampleOffset;
                    }
                    while (outSampleOffset < endSampleOffset) {
                        int iInIndex = (int)inSampleOffset;
                        float factor = (float)(inSampleOffset - (double)iInIndex);
                        outSamples[outSampleOffset] = inSamples[iInIndex - 1] * (1.0f - factor) + inSamples[iInIndex] * factor;
                        inSampleOffset += increment;
                        ++outSampleOffset;
                    }
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    if (TDebug.TraceAllExceptions) {
                        TDebug.out("**** INDEX OUT OF BOUNDS ****** inSampleOffset=" + inSampleOffset + "  inSamples.length=" + inSamples.length + "  outSampleOffset=" + outSampleOffset + "  outSamples.length=" + outSamples.length);
                    }
                    if (!TDebug.TraceAllExceptions) break block6;
                    aioobe.printStackTrace();
                }
            }
        }

        private double inSamples2outSamples(double inSamples) {
            return inSamples * (double)this.targetSampleRate / (double)this.sourceSampleRate;
        }

        private double outSamples2inSamples(double outSamples) {
            return outSamples * (double)this.sourceSampleRate / (double)this.targetSampleRate;
        }

        public int getChannels() {
            return this.getFormat().getChannels();
        }

        public float getSampleRate() {
            return this.getFormat().getSampleRate();
        }

        public boolean isDone() {
            return this.isClosed();
        }

        public void read(FloatSampleBuffer outBuffer) {
            this.read(outBuffer, 0, outBuffer.getSampleCount());
        }

        public void read(FloatSampleBuffer outBuffer, int offset, int count) {
            int writeCount;
            if (this.isClosed() || count == 0) {
                outBuffer.setSampleCount(offset, true);
                return;
            }
            if (outBuffer.getChannelCount() != this.thisBuffer.getChannelCount()) {
                throw new IllegalArgumentException("passed buffer has different channel count");
            }
            if (TDebug.TraceAudioConverter) {
                // empty if block
            }
            FloatSampleBuffer lSourceBuffer = this.thisBuffer;
            double increment = this.outSamples2inSamples(1.0);
            int writtenSamples = 0;
            do {
                int inSampleCount;
                if ((int)this.dPos >= (inSampleCount = lSourceBuffer.getSampleCount()) || !this.thisBufferValid) {
                    this.readFromSourceStream();
                    if (this.isClosed()) break;
                    lSourceBuffer = this.thisBuffer;
                    inSampleCount = this.thisBuffer.getSampleCount();
                    if (inSampleCount == 0) break;
                }
                if ((int)(this.outSamples2inSamples(writeCount = count - writtenSamples) + this.dPos) >= inSampleCount) {
                    int lastOutIndex = (int)this.inSamples2outSamples((double)inSampleCount - this.dPos) + 1;
                    while ((int)(this.outSamples2inSamples(lastOutIndex) + this.dPos) >= inSampleCount) {
                        --lastOutIndex;
                    }
                    writeCount = lastOutIndex + 1;
                }
                block6: for (int channel = 0; channel < outBuffer.getChannelCount(); ++channel) {
                    float[] inSamples = lSourceBuffer.getChannel(channel);
                    float[] outSamples = outBuffer.getChannel(channel);
                    float[] history = this.historyBuffer.getChannel(channel);
                    switch (this.conversionAlgorithm) {
                        case 1: {
                            this.convertSampleAndHold2(inSamples, this.dPos, inSampleCount, increment, outSamples, writtenSamples + offset, writeCount, history, this.historyBuffer.getSampleCount());
                            continue block6;
                        }
                        case 2: {
                            this.convertLinearInterpolation2(inSamples, this.dPos, inSampleCount, increment, outSamples, writtenSamples + offset, writeCount, history, this.historyBuffer.getSampleCount());
                        }
                    }
                }
                this.dPos += this.outSamples2inSamples(writeCount);
            } while (!this.isClosed() && (writtenSamples += writeCount) < outBuffer.getSampleCount());
            if (writtenSamples < count) {
                outBuffer.changeSampleCount(writtenSamples + offset, true);
            }
            if (TDebug.TraceAudioConverter) {
                // empty if block
            }
        }

        protected double sourceFrames2targetFrames(double sourceFrames) {
            return (double)(this.targetSampleRate / this.sourceSampleRate) * sourceFrames;
        }

        protected double targetFrames2sourceFrames(double targetFrames) {
            return (double)(this.sourceSampleRate / this.targetSampleRate) * targetFrames;
        }

        protected long sourceBytes2targetBytes(long sourceBytes) {
            long sourceFrames = sourceBytes / (long)this.getSourceFrameSize();
            long targetFrames = (long)this.sourceFrames2targetFrames(sourceFrames);
            return targetFrames * (long)this.getFrameSize();
        }

        protected long targetBytes2sourceBytes(long targetBytes) {
            long targetFrames = targetBytes / (long)this.getFrameSize();
            long sourceFrames = (long)this.targetFrames2sourceFrames(targetFrames);
            return sourceFrames * (long)this.getSourceFrameSize();
        }

        public int getFrameSize() {
            return this.getFormat().getFrameSize();
        }

        public int getSourceFrameSize() {
            return this.sourceStream != null ? this.sourceStream.getFormat().getFrameSize() : 1;
        }

        public int read() throws IOException {
            if (this.getFormat().getFrameSize() != 1) {
                throw new IOException("frame size must be 1 to read a single byte");
            }
            byte[] temp = new byte[1];
            int result = this.read(temp);
            if (result <= 0) {
                return -1;
            }
            return temp[0] & 0xFF;
        }

        public int read(byte[] abData) throws IOException {
            return this.read(abData, 0, abData.length);
        }

        public int read(byte[] abData, int nOffset, int nLength) throws IOException {
            if (this.isClosed()) {
                return -1;
            }
            int frameCount = nLength / this.getFrameSize();
            if (this.writeBuffer == null) {
                this.writeBuffer = new FloatSampleBuffer(this.getFormat().getChannels(), frameCount, this.getFormat().getSampleRate());
            } else {
                this.writeBuffer.changeSampleCount(frameCount, false);
            }
            this.read(this.writeBuffer);
            if (this.writeBuffer.getSampleCount() == 0 && this.eofReached) {
                return -1;
            }
            int written = this.writeBuffer.convertToByteArray(abData, nOffset, this.getFormat());
            return written;
        }

        public synchronized long skip(long nSkip) throws IOException {
            long sourceSkip = this.targetBytes2sourceBytes(nSkip);
            long sourceSkipped = this.sourceStream != null ? this.sourceStream.skip(sourceSkip) : 0L;
            this.flush();
            return this.sourceBytes2targetBytes(sourceSkipped);
        }

        public int available() throws IOException {
            if (this.sourceStream == null) {
                return -1;
            }
            return (int)this.sourceBytes2targetBytes(this.sourceStream.available());
        }

        public void mark(int readlimit) {
            if (this.sourceStream != null) {
                this.sourceStream.mark((int)this.targetBytes2sourceBytes(readlimit));
            }
        }

        public synchronized void reset() throws IOException {
            if (this.sourceStream != null) {
                this.sourceStream.reset();
                this.flush();
            }
        }

        public boolean markSupported() {
            if (this.sourceStream != null) {
                return this.sourceStream.markSupported();
            }
            return false;
        }

        public void close() {
            if (this.isClosed()) {
                return;
            }
            if (this.sourceStream != null) {
                try {
                    this.sourceStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.eofReached = true;
            this.thisBuffer = null;
            this.historyBuffer = null;
            this.byteBuffer = null;
        }

        public boolean isClosed() {
            return this.eofReached || this.thisBuffer == null;
        }

        public synchronized void flush() {
            if (!this.isClosed()) {
                this.thisBufferValid = false;
                this.historyBuffer.makeSilence();
            }
        }

        public synchronized void setTargetSampleRate(float sr) {
            if (sr > 0.0f) {
                this.targetSampleRate = sr;
                this.resizeBuffers();
            }
        }

        public synchronized void setConversionAlgorithm(int algo) {
            if ((algo == 1 || algo == 2) && algo != this.conversionAlgorithm) {
                this.conversionAlgorithm = algo;
                this.resizeBuffers();
            }
        }

        public synchronized float getTargetSampleRate() {
            return this.targetSampleRate;
        }

        public synchronized int getConversionAlgorithm() {
            return this.conversionAlgorithm;
        }
    }
}

