/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.alsa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.spi.MidiDeviceProvider;
import org.tritonus.lowlevel.alsa.AlsaSeq;
import org.tritonus.lowlevel.alsa.AlsaSeqClientInfo;
import org.tritonus.lowlevel.alsa.AlsaSeqPortInfo;
import org.tritonus.midi.device.alsa.AlsaMidiDevice;
import org.tritonus.midi.device.alsa.AlsaSynthesizer;
import org.tritonus.share.TDebug;

public class AlsaMidiDeviceProvider
extends MidiDeviceProvider {
    private static final MidiDevice.Info[] EMPTY_INFO_ARRAY = new MidiDevice.Info[0];
    private static final int READ_CAPABILITY = 33;
    private static final int WRITE_CAPABILITY = 66;
    private static List<MidiDevice> m_devices;
    private static AlsaSeq m_alsaSeq;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlsaMidiDeviceProvider() {
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaMidiDeviceProvider.<init>(): begin");
        }
        Class<AlsaMidiDeviceProvider> clazz = AlsaMidiDeviceProvider.class;
        synchronized (AlsaMidiDeviceProvider.class) {
            if (m_devices == null) {
                m_devices = new ArrayList<MidiDevice>();
                if (TDebug.TraceMidiDeviceProvider) {
                    TDebug.out("AlsaMidiDeviceProvider.<init>(): creating AlsaSeq...");
                }
                m_alsaSeq = new AlsaSeq("Tritonus ALSA device manager");
                if (TDebug.TraceMidiDeviceProvider) {
                    TDebug.out("AlsaMidiDeviceProvider.<init>(): ...done");
                }
                this.scanPorts();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (TDebug.TraceMidiDeviceProvider) {
                TDebug.out("AlsaMidiDeviceProvider.<init>(): end");
            }
            return;
        }
    }

    public MidiDevice.Info[] getDeviceInfo() {
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaMidiDeviceProvider.getDeviceInfo(): begin");
        }
        ArrayList<MidiDevice.Info> infoList = new ArrayList<MidiDevice.Info>();
        for (MidiDevice device : m_devices) {
            MidiDevice.Info info = device.getDeviceInfo();
            infoList.add(info);
        }
        MidiDevice.Info[] infos = infoList.toArray(EMPTY_INFO_ARRAY);
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaMidiDeviceProvider.getDeviceInfo(): end");
        }
        return infos;
    }

    public MidiDevice getDevice(MidiDevice.Info info) {
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaMidiDeviceProvider.getDevice(): begin");
        }
        MidiDevice returnedDevice = null;
        for (MidiDevice device : m_devices) {
            MidiDevice.Info info2 = device.getDeviceInfo();
            if (info == null || !info.equals(info2)) continue;
            returnedDevice = device;
            break;
        }
        if (returnedDevice == null) {
            throw new IllegalArgumentException("no device for " + info);
        }
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaMidiDeviceProvider.getDevice(): end");
        }
        return returnedDevice;
    }

    private void scanPorts() {
        if (TDebug.TraceMidiDeviceProvider || TDebug.TracePortScan) {
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): begin");
        }
        Iterator clients = m_alsaSeq.getClientInfos();
        while (clients.hasNext()) {
            AlsaSeqClientInfo clientInfo = (AlsaSeqClientInfo)clients.next();
            int nClient = clientInfo.getClient();
            if (TDebug.TracePortScan) {
                TDebug.out("AlsaMidiDeviceProvider.scanPorts(): client: " + nClient);
            }
            Iterator ports = m_alsaSeq.getPortInfos(nClient);
            while (ports.hasNext()) {
                AlsaSeqPortInfo portInfo = (AlsaSeqPortInfo)ports.next();
                this.handlePort(clientInfo, portInfo);
            }
        }
        if (TDebug.TraceMidiDeviceProvider || TDebug.TracePortScan) {
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): end");
        }
    }

    private void handlePort(AlsaSeqClientInfo clientInfo, AlsaSeqPortInfo portInfo) {
        int nClient = clientInfo.getClient();
        int nPort = portInfo.getPort();
        int nType = portInfo.getType();
        int nCapability = portInfo.getCapability();
        int nSynthVoices = portInfo.getSynthVoices();
        if (TDebug.TracePortScan) {
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): port: " + nPort);
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): type: " + nType);
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): cap: " + nCapability);
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): midi channels: " + portInfo.getMidiChannels());
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): midi voices: " + portInfo.getMidiVoices());
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): synth voices: " + portInfo.getSynthVoices());
        }
        if ((nType & 2) != 0) {
            AlsaMidiDevice device = null;
            if ((nType & 0x1C00) != 0) {
                boolean bWriteSubscriptionAllowed;
                boolean bl = bWriteSubscriptionAllowed = (nCapability & 0x42) == 66;
                if (bWriteSubscriptionAllowed) {
                    device = new AlsaSynthesizer(nClient, nPort, nSynthVoices);
                } else if (TDebug.TraceMidiDeviceProvider) {
                    TDebug.out("AlsaMidiDeviceProvider.getDevice(): port does not allows write subscription, not used");
                }
            } else {
                boolean bWriteSubscriptionAllowed;
                boolean bReadSubscriptionAllowed = (nCapability & 0x21) == 33;
                boolean bl = bWriteSubscriptionAllowed = (nCapability & 0x42) == 66;
                if (bReadSubscriptionAllowed || bWriteSubscriptionAllowed) {
                    device = new AlsaMidiDevice(nClient, nPort, bReadSubscriptionAllowed, bWriteSubscriptionAllowed);
                } else if (TDebug.TraceMidiDeviceProvider) {
                    TDebug.out("AlsaMidiDeviceProvider.getDevice(): port allows neither read nor write subscription, not used");
                }
            }
            if (device != null) {
                m_devices.add(device);
            }
        }
    }
}

