/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.lowlevel.pogg;

import java.io.UnsupportedEncodingException;
import org.tritonus.lowlevel.pogg.Ogg;
import org.tritonus.share.TDebug;

public class Buffer {
    private long m_lNativeHandle;

    public Buffer() {
        int nReturn;
        if (TDebug.TraceOggNative) {
            TDebug.out("Buffer.<init>(): begin");
        }
        if ((nReturn = this.malloc()) < 0) {
            throw new RuntimeException("malloc of ogg_page failed");
        }
        if (TDebug.TraceOggNative) {
            TDebug.out("Buffer.<init>(): end");
        }
    }

    public void finalize() {
    }

    private native int malloc();

    public native void free();

    public native void writeInit();

    public native void writeTrunc(int var1);

    public native void writeAlign();

    public native void writeCopy(byte[] var1, int var2);

    public native void reset();

    public native void writeClear();

    public native void readInit(byte[] var1, int var2);

    public native void write(int var1, int var2);

    public native int look(int var1);

    public native int look1();

    public native void adv(int var1);

    public native void adv1();

    public native int read(int var1);

    public native int read1();

    public native int bytes();

    public native int bits();

    public native byte[] getBuffer();

    public void write(String str) {
        this.write(str, false);
    }

    public void writeWithLength(String str) {
        this.write(str, true);
    }

    private void write(String str, boolean bWithLength) {
        byte[] aBytes;
        block4: {
            aBytes = null;
            try {
                aBytes = str.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if (!TDebug.TraceAllExceptions) break block4;
                TDebug.out(e);
            }
        }
        if (bWithLength) {
            this.write(aBytes.length, 32);
        }
        for (int i = 0; i < aBytes.length; ++i) {
            this.write(aBytes[i], 8);
        }
    }

    public String readString() {
        int length = this.read(32);
        if (length < 0) {
            return null;
        }
        return this.readString(length);
    }

    public String readString(int nLength) {
        String s;
        block3: {
            byte[] aBytes = new byte[nLength];
            for (int i = 0; i < nLength; ++i) {
                aBytes[i] = (byte)this.read(8);
            }
            s = null;
            try {
                s = new String(aBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if (!TDebug.TraceAllExceptions) break block3;
                TDebug.out(e);
            }
        }
        return s;
    }

    public boolean readFlag() {
        return this.read(1) != 0;
    }

    private static native void setTrace(boolean var0);

    public static void outBuffer(byte[] buffer) {
        String s = "";
        for (int i = 0; i < buffer.length; ++i) {
            s = s + "" + buffer[i] + ", ";
        }
        TDebug.out("buffer: " + s);
    }

    static {
        Ogg.loadNativeLibrary();
        if (TDebug.TraceOggNative) {
            Buffer.setTrace(true);
        }
    }
}

