/*
 * Decompiled with CFR 0.152.
 */
package com.byteslooser.filters.gui.editors;

import com.byteslooser.filters.AbstractObservableRowFilter;
import com.byteslooser.filters.IFilterObservable;
import com.byteslooser.filters.artifacts.RowFilter;
import com.byteslooser.filters.gui.ITableFilterEditor;
import com.byteslooser.filters.resources.Messages;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ChoiceFilterEditor
extends JComboBox
implements ITableFilterEditor {
    public static final String NO_FILTER = new String(" ");
    protected int filterPosition;
    protected Object[] choices;
    protected Object otherChoices;
    protected Object currentChoice = NO_FILTER;
    protected Filter filter = new Filter();

    public ChoiceFilterEditor() {
        this(-1, null, new Object[0]);
    }

    public ChoiceFilterEditor(int filterPosition, Object labelForOtherChoices, Object ... choices) {
        this.setFilterPosition(filterPosition);
        this.setChoices(this.otherChoices, choices);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChoiceFilterEditor.this.filter.propagateFilterChange(false);
            }
        });
        this.setRenderer(new DefaultListCellRenderer(){
            final String EMPTY_VALUE = new String(Messages.getString("ChoiceFilterEditor.EmptyValue"));
            final String NULL_VALUE = new String(Messages.getString("ChoiceFilterEditor.NullValue"));

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String val;
                if (value == NO_FILTER) {
                    val = (String)value;
                } else if (value == null) {
                    val = this.NULL_VALUE;
                } else {
                    val = value.toString();
                    if (val.length() == 0) {
                        val = this.EMPTY_VALUE;
                    }
                }
                return super.getListCellRendererComponent((JList<?>)list, val, index, isSelected, cellHasFocus);
            }
        });
    }

    public void setChoices(IChoice ... choices) {
        this.setChoices(null, (Object[])choices);
    }

    public void setChoices(Object otherChoices, Object ... choices) {
        this.otherChoices = otherChoices;
        this.choices = choices;
        this.setChoiceModel(NO_FILTER, otherChoices, choices);
    }

    public void setChoiceRenderer(final IRenderer renderer) {
        this.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return renderer.getChoiceComponent(value, isSelected, cellHasFocus);
            }
        });
    }

    public void setFilterPosition(int filterPosition) {
        this.filterPosition = filterPosition;
        this.filter.propagateFilterChange(true);
    }

    public int getFilterPosition() {
        return this.filterPosition;
    }

    @Override
    public IFilterObservable getFilterObservable() {
        return this.filter;
    }

    @Override
    public void updateFilter() {
        this.filter.propagateFilterChange(true);
    }

    @Override
    public void resetFilter() {
        this.getModel().setSelectedItem(NO_FILTER);
        this.filter.propagateFilterChange(false);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    protected void setChoiceModel(Object selected, Object otherChoices, Object[] choices) {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(choices);
        model.insertElementAt(NO_FILTER, 0);
        if (otherChoices != null) {
            model.addElement(otherChoices);
        }
        if (selected != null) {
            model.setSelectedItem(selected);
        }
        this.setModel(model);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.filter.propagateFilterChange(true);
    }

    protected class Filter
    extends AbstractObservableRowFilter {
        protected Filter() {
        }

        public void propagateFilterChange(boolean forced) {
            Object selected = ChoiceFilterEditor.this.isEnabled() ? ChoiceFilterEditor.this.getSelectedItem() : NO_FILTER;
            if (forced || selected != ChoiceFilterEditor.this.currentChoice) {
                ChoiceFilterEditor.this.currentChoice = selected;
                this.reportFilterUpdatedToObservers();
            }
        }

        @Override
        public boolean include(RowFilter.Entry rowEntry) {
            if (ChoiceFilterEditor.this.currentChoice == NO_FILTER) {
                return true;
            }
            Object val = rowEntry.getValue(ChoiceFilterEditor.this.filterPosition);
            if (ChoiceFilterEditor.this.currentChoice == ChoiceFilterEditor.this.otherChoices) {
                int c = ChoiceFilterEditor.this.getItemCount();
                while (c-- > 0) {
                    Object o = ChoiceFilterEditor.this.getItemAt(c);
                    if (o == NO_FILTER || o == ChoiceFilterEditor.this.otherChoices || !(o == null ? val == null : o.equals(val))) continue;
                    return false;
                }
                return true;
            }
            if (ChoiceFilterEditor.this.currentChoice instanceof IChoice) {
                return ((IChoice)ChoiceFilterEditor.this.currentChoice).matches(val);
            }
            return val == null ? ChoiceFilterEditor.this.currentChoice == null : val.equals(ChoiceFilterEditor.this.currentChoice);
        }
    }

    public static interface IRenderer {
        public Component getChoiceComponent(Object var1, boolean var2, boolean var3);
    }

    public static interface IChoice {
        public boolean matches(Object var1);
    }
}

