/*
 * Decompiled with CFR 0.152.
 */
package uk.co.xfactorylibrarians.coremidi4j;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiDeviceReceiver;
import javax.sound.midi.MidiMessage;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDestination;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceInfo;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceProvider;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiException;

public class CoreMidiReceiver
implements MidiDeviceReceiver {
    private final CoreMidiDestination device;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    CoreMidiReceiver(CoreMidiDestination device) {
        this.device = device;
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        if (this.closed.get()) {
            throw new IllegalStateException("Can't call send() with a closed receiver");
        }
        if (!this.device.isOpen()) {
            throw new IllegalStateException("Can't call send with a receiver attached to a device that is not open: " + this.device);
        }
        try {
            long coreTimestamp = timeStamp == -1L ? 0L : timeStamp + this.device.getStartTime();
            CoreMidiDeviceProvider.getOutputPort().send(((CoreMidiDeviceInfo)this.device.getDeviceInfo()).getEndPointReference(), message, coreTimestamp);
        }
        catch (CoreMidiException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.device.receiverClosed(this);
        }
    }

    @Override
    public MidiDevice getMidiDevice() {
        return this.device;
    }
}

