/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.esd;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.tritonus.lowlevel.esd.EsdRecordingStream;
import org.tritonus.sampled.mixer.esd.EsdUtils;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.mixer.TBaseDataLine;
import org.tritonus.share.sampled.mixer.TMixer;

public class EsdTargetDataLine
extends TBaseDataLine
implements TargetDataLine {
    private EsdRecordingStream m_esdStream;
    private boolean m_bSwapBytes;
    private byte[] m_abSwapBuffer;
    private int m_nBytesPerSample;

    public EsdTargetDataLine(TMixer mixer, AudioFormat format, int nBufferSize) throws LineUnavailableException {
        super(mixer, new DataLine.Info(TargetDataLine.class, format, nBufferSize));
    }

    protected void openImpl() {
        if (TDebug.TraceTargetDataLine) {
            TDebug.out("EsdTargetDataLine.openImpl(): called.");
        }
        this.checkOpen();
        AudioFormat format = this.getFormat();
        AudioFormat.Encoding encoding = format.getEncoding();
        boolean bBigEndian = format.isBigEndian();
        this.m_bSwapBytes = false;
        if (format.getSampleSizeInBits() == 16 && bBigEndian) {
            this.m_bSwapBytes = true;
            bBigEndian = false;
        } else if (format.getSampleSizeInBits() == 8 && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            this.m_bSwapBytes = true;
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (this.m_bSwapBytes) {
            format = new AudioFormat(encoding, format.getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), format.getFrameSize(), format.getFrameRate(), bBigEndian);
            this.m_nBytesPerSample = format.getFrameSize() / format.getChannels();
        }
        int nOutFormat = 0x1000 | EsdUtils.getEsdFormat(format);
        this.m_esdStream = new EsdRecordingStream();
        this.m_esdStream.open(nOutFormat, (int)format.getSampleRate());
    }

    public int available() {
        return -1;
    }

    public int read(byte[] abData, int nOffset, int nLength) {
        if (TDebug.TraceTargetDataLine) {
            TDebug.out("EsdTargetDataLine.read(): called.");
            TDebug.out("EsdTargetDataLine.read(): wanted length: " + nLength);
        }
        int nOriginalOffset = nOffset;
        if (nLength > 0 && !this.isActive()) {
            this.start();
        }
        if (!this.isOpen() && TDebug.TraceTargetDataLine) {
            TDebug.out("EsdTargetDataLine.read(): stream closed");
        }
        int nBytesRead = this.m_esdStream.read(abData, nOffset, nLength);
        if (TDebug.TraceTargetDataLine) {
            TDebug.out("EsdTargetDataLine.read(): read (bytes): " + nBytesRead);
        }
        if (this.m_bSwapBytes && nBytesRead > 0) {
            TConversionTool.swapOrder16(abData, nOriginalOffset, nBytesRead / 2);
        }
        return nBytesRead;
    }

    public void closeImpl() {
        this.m_esdStream.close();
    }

    public void drain() {
    }

    public void flush() {
    }

    public long getPosition() {
        return 0L;
    }

    protected void setGain(float fGain) {
    }

    public class EsdTargetDataLineGainControl
    extends FloatControl {
        private final float MAX_GAIN = 90.0f;
        private final float MIN_GAIN = -96.0f;
        private final int GAIN_INCREMENTS = 1000;

        EsdTargetDataLineGainControl() {
            super(FloatControl.Type.VOLUME, -96.0f, 24.0f, 0.01f, 0, 0.0f, "dB", "-96.0", "", "+24.0");
            this.MAX_GAIN = 90.0f;
            this.MIN_GAIN = -96.0f;
            this.GAIN_INCREMENTS = 1000;
        }

        public void setValue(float fGain) {
            if ((double)Math.abs((fGain = Math.max(Math.min(fGain, this.getMaximum()), this.getMinimum())) - this.getValue()) > 1.0E9) {
                super.setValue(fGain);
                EsdTargetDataLine.this.setGain(this.getValue());
            }
        }
    }
}

