/*
 * Decompiled with CFR 0.152.
 */
package com.byteslooser.filters.parser.generic;

import com.byteslooser.filters.artifacts.RowFilter;
import com.byteslooser.filters.parser.FilterTextParsingException;
import com.byteslooser.filters.parser.IFilterTextParser;
import com.byteslooser.filters.parser.ITypeBuilder;
import com.byteslooser.filters.parser.IdentifierInfo;
import com.byteslooser.filters.parser.generic.IOperator;
import com.byteslooser.filters.parser.generic.IRelationalOperand;
import com.byteslooser.filters.parser.generic.IRelationalOperandFactory;
import com.byteslooser.filters.parser.generic.ITypesFactory;
import com.byteslooser.filters.parser.generic.OperandFactory;
import com.byteslooser.filters.parser.generic.TypesFactory;
import com.byteslooser.filters.resources.Messages;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilterTextParser
implements IFilterTextParser {
    public static final char SPACE_CHAR = ' ';
    public static final char ESCAPE_CHAR = '\\';
    public static final char AND_CHAR = '&';
    public static final char OR_CHAR = '|';
    public static final char OPEN_PARENTHESIS_CHAR = '(';
    public static final char CLOSE_PARENTHESIS_CHAR = ')';
    public static final String DEFAULT_NULL_STRING = Messages.getString("FilterTextParser.NullFilterText");
    static final String INVALID_OPERAND_EXCEPTION = Messages.getString("FilterTextParser.InvalidOperand");
    static final String INVALID_OPERAND_IDENTIFIER_EXCEPTION = Messages.getString("FilterTextParser.InvalidOperandForIdentifier");
    static final String INVALID_TYPE_EXCEPTION = Messages.getString("FilterTextParser.InvalidType");
    static final String UNCOMPLETE_FILTER_EXCEPTION = Messages.getString("FilterTextParser.UncompleteFilter");
    static final String UNEXPECTED_TEXT_EXCEPTION = Messages.getString("FilterTextParser.UnexpectedText");
    static final String INVALID_IDENTIFIER_EXCEPTION = Messages.getString("FilterTextParser.InvalidIdentifier");
    private Map<String, IdentifierInfo> identifiers;
    IRelationalOperandFactory operandFactory;
    ITypesFactory typesFactory;
    private Parser parser;
    String nullString = DEFAULT_NULL_STRING;

    public FilterTextParser() {
        this(null, null);
    }

    public FilterTextParser(IRelationalOperandFactory operandFactory) {
        this(operandFactory, null);
    }

    public FilterTextParser(ITypesFactory typesFactory) {
        this(null, typesFactory);
    }

    public FilterTextParser(IRelationalOperandFactory operandFactory, ITypesFactory typesFactory) {
        this.operandFactory = operandFactory == null ? new OperandFactory() : operandFactory;
        this.typesFactory = typesFactory == null ? new TypesFactory() : typesFactory;
        this.identifiers = new HashMap<String, IdentifierInfo>();
        this.parser = new Parser();
    }

    @Override
    public void setIgnoreCase(boolean ignore) {
        this.operandFactory.setIgnoreCase(ignore);
    }

    @Override
    public void setIdentifiers(List<IdentifierInfo> validIdentifiers) {
        this.identifiers.clear();
        for (IdentifierInfo info : validIdentifiers) {
            this.identifiers.put(info.name, info);
        }
    }

    public void setComparator(Class<?> c, Comparator<?> cmp) {
        this.operandFactory.setComparator(c, cmp);
    }

    public void setTypeBuilder(Class<?> c, ITypeBuilder parser) {
        this.typesFactory.setFactory(c, parser);
    }

    @Override
    public RowFilter parseText(String exp, int defaultFilterPosition) throws FilterTextParsingException {
        return this.parser.parseText(exp, this.getIdentifier(defaultFilterPosition));
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    private IdentifierInfo getIdentifier(int filterPosition) {
        if (filterPosition == -1) {
            return null;
        }
        for (IdentifierInfo info : this.identifiers.values()) {
            if (info.filterPosition != filterPosition) continue;
            return info;
        }
        return null;
    }

    IdentifierInfo getIdentifierIgnoringCase(String identifier) {
        IdentifierInfo ret = this.identifiers.get(identifier);
        if (ret == null) {
            for (String i : this.identifiers.keySet()) {
                if (!i.equalsIgnoreCase(identifier)) continue;
                return this.identifiers.get(i);
            }
        }
        return ret;
    }

    class Parser {
        private int parsingPosition;
        private IdentifierInfo defaultIdentifier;
        private String expression;

        Parser() {
        }

        public FilterNode parseText(String exp, IdentifierInfo defaultIdentifier) throws FilterTextParsingException {
            this.parsingPosition = 0;
            this.defaultIdentifier = defaultIdentifier;
            this.expression = exp;
            return this.parse(exp.toCharArray(), false);
        }

        private FilterNode parse(char[] characters, boolean closeParenthesisExpected) throws FilterTextParsingException {
            FilterNode currentNode;
            FilterNode returningNode = currentNode = new FilterNode();
            boolean escape = false;
            int firstCharacter = this.parsingPosition;
            int lengthString = 0;
            StringBuilder sb = new StringBuilder();
            int len = characters.length;
            IdentifierInfo identifier = null;
            IRelationalOperand operand = null;
            block10: while (this.parsingPosition < len) {
                char c = characters[this.parsingPosition++];
                if (escape) {
                    switch (c) {
                        case ' ': 
                        case '&': 
                        case '(': 
                        case ')': 
                        case '\\': 
                        case '|': {
                            break;
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(c);
                    escape = false;
                    lengthString = sb.length();
                    continue;
                }
                switch (c) {
                    case ' ': {
                        if (sb.length() > 0) {
                            sb.append(c);
                            continue block10;
                        }
                        firstCharacter = this.parsingPosition;
                        continue block10;
                    }
                    case '\\': {
                        escape = true;
                        continue block10;
                    }
                    case '(': {
                        if (sb.length() > 0 || !currentNode.acceptRight()) {
                            this.throwBasicParsingException(this.parsingPosition - 1);
                        }
                        currentNode = currentNode.right = this.parse(characters, true);
                        continue block10;
                    }
                    case ')': {
                        if (lengthString > 0) {
                            currentNode.right = this.createFilterNode(identifier, operand, firstCharacter, sb.substring(0, lengthString));
                        }
                        if (!closeParenthesisExpected || !currentNode.isComplete()) {
                            this.throwBasicParsingException(this.parsingPosition - 1);
                        }
                        return returningNode.right;
                    }
                    case '&': 
                    case '|': {
                        if (lengthString > 0) {
                            currentNode.right = this.createFilterNode(identifier, operand, firstCharacter, sb.substring(0, lengthString));
                            if (currentNode.isRoot()) {
                                currentNode = currentNode.right;
                            }
                        } else if (!currentNode.isComplete()) {
                            this.throwBasicParsingException(this.parsingPosition - 1);
                        }
                        currentNode.createLogicalCondition(c == '&');
                        sb.delete(0, sb.length());
                        firstCharacter = this.parsingPosition;
                        operand = null;
                        lengthString = 0;
                        continue block10;
                    }
                }
                if (currentNode.acceptRight()) {
                    if (operand == null && (operand = FilterTextParser.this.operandFactory.getOperand(c, this.expression, this.parsingPosition)) != null) {
                        identifier = this.getIdentifier(sb.substring(0, lengthString), firstCharacter);
                        if (!operand.appliesOnType(this.getIdentifierClass(identifier))) {
                            String error = identifier == null ? String.format(INVALID_OPERAND_EXCEPTION, operand.toString()) : String.format(INVALID_OPERAND_IDENTIFIER_EXCEPTION, operand.toString(), identifier);
                            throw new FilterTextParsingException(error, this.parsingPosition - 1);
                        }
                        firstCharacter = this.parsingPosition += operand.symbolLength() - 1;
                        sb.delete(0, sb.length());
                        continue;
                    }
                    sb.append(c);
                    lengthString = sb.length();
                    continue;
                }
                this.throwBasicParsingException(this.parsingPosition - 1);
            }
            if (escape) {
                this.throwBasicParsingException(len - 1);
            }
            if (closeParenthesisExpected) {
                this.throwBasicParsingException(len);
            }
            if (lengthString > 0) {
                currentNode.right = this.createFilterNode(identifier, operand, firstCharacter, sb.substring(0, lengthString));
            } else if (operand != null) {
                this.throwBasicParsingException(len);
            } else if (!currentNode.isComplete() && !returningNode.isEmpty()) {
                this.throwBasicParsingException(len);
            }
            return returningNode.right;
        }

        private FilterNode createFilterNode(IdentifierInfo identifier, IRelationalOperand operand, int firstCharacter, String content) throws FilterTextParsingException {
            boolean nullOp;
            Object info = null;
            if (identifier == null) {
                identifier = this.defaultIdentifier;
            }
            Class<?> base = this.getIdentifierClass(identifier);
            IdentifierInfo rightIdentifier = null;
            if (!(identifier == null || base == String.class || operand != null && operand.stringBased() || (rightIdentifier = FilterTextParser.this.getIdentifierIgnoringCase(content)) == null || base == this.getIdentifierClass(rightIdentifier))) {
                rightIdentifier = null;
            }
            boolean bl = nullOp = rightIdentifier == null ? content.equals(FilterTextParser.this.nullString) : false;
            if (operand == null) {
                operand = FilterTextParser.this.operandFactory.getDefaultOperand(base, nullOp, rightIdentifier != null);
            }
            AbstractFilterLeaf leaf = null;
            if (rightIdentifier != null) {
                leaf = new FilterLeaf(identifier, operand, rightIdentifier);
            } else {
                IOperator op;
                if (!nullOp) {
                    if (operand.stringBased()) {
                        info = content;
                    } else {
                        int errorPosition = firstCharacter;
                        try {
                            info = FilterTextParser.this.typesFactory.buildObject(base, content);
                        }
                        catch (FilterTextParsingException ex) {
                            errorPosition += ex.getPosition();
                        }
                        if (info == null) {
                            throw new FilterTextParsingException(String.format(INVALID_TYPE_EXCEPTION, base.getSimpleName(), this.expression.substring(errorPosition)), errorPosition);
                        }
                    }
                }
                if ((op = operand.createOperator(info)) == null) {
                    this.throwBasicParsingException(firstCharacter - 1);
                }
                leaf = new ConstFilterLeaf(identifier, op);
            }
            return new FilterNode(leaf);
        }

        private void throwBasicParsingException(int position) throws FilterTextParsingException {
            if (position >= this.expression.length()) {
                throw new FilterTextParsingException(String.format(UNCOMPLETE_FILTER_EXCEPTION, this.expression), this.expression.length());
            }
            throw new FilterTextParsingException(String.format(UNEXPECTED_TEXT_EXCEPTION, this.expression.substring(0, position)), position);
        }

        private Class<?> getIdentifierClass(IdentifierInfo identifier) {
            return FilterTextParser.this.typesFactory.getBuildType(identifier == null ? String.class : identifier.associatedClass);
        }

        private IdentifierInfo getIdentifier(String given, int firstCharacter) throws FilterTextParsingException {
            if (given.length() == 0) {
                return this.defaultIdentifier;
            }
            IdentifierInfo ret = FilterTextParser.this.getIdentifierIgnoringCase(given);
            if (ret == null) {
                throw new FilterTextParsingException(String.format(INVALID_IDENTIFIER_EXCEPTION, given), firstCharacter);
            }
            return ret;
        }
    }

    static class FilterNode
    extends RowFilter {
        boolean and;
        AbstractFilterLeaf info;
        FilterNode left;
        FilterNode right;

        FilterNode() {
            this.left = this;
        }

        FilterNode(AbstractFilterLeaf info) {
            this.info = info;
        }

        @Override
        public boolean include(RowFilter.Entry rowEntry) {
            if (this.info != null) {
                return this.info.include(rowEntry);
            }
            boolean start = this.left.include(rowEntry);
            if (this.and) {
                return start && this.right.include(rowEntry);
            }
            return start || this.right.include(rowEntry);
        }

        void createLogicalCondition(boolean andCondition) {
            FilterNode newLeft = new FilterNode();
            newLeft.and = this.and;
            newLeft.info = this.info;
            newLeft.left = this.left;
            newLeft.right = this.right;
            this.info = null;
            this.and = andCondition;
            this.left = newLeft;
            this.right = null;
        }

        boolean isRoot() {
            return this.left == this;
        }

        boolean acceptRight() {
            return this.info == null && this.right == null;
        }

        boolean isLeaf() {
            return this.info != null;
        }

        boolean isComplete() {
            return this.info != null || this.left != null && this.right != null;
        }

        boolean isEmpty() {
            return this.info == null && this.left == this && this.right == null;
        }

        AbstractFilterLeaf getContent() {
            return this.info;
        }
    }

    static class FilterLeaf
    extends AbstractFilterLeaf {
        IRelationalOperand op;
        IdentifierInfo rightIdentifier;

        FilterLeaf(IdentifierInfo identifier, IRelationalOperand op, IdentifierInfo rightIdentifier) {
            super(identifier);
            this.op = op;
            this.rightIdentifier = rightIdentifier;
        }

        @Override
        public boolean include(RowFilter.Entry rowEntry) {
            IOperator operator = this.op.createOperator(rowEntry.getValue(this.rightIdentifier.filterPosition));
            return operator != null && operator.apply(rowEntry.getValue(this.identifier.filterPosition));
        }

        public String toString() {
            return this.identifier.name + " " + this.op.toString() + " " + this.rightIdentifier.name;
        }
    }

    class ConstFilterLeaf
    extends AbstractFilterLeaf {
        IOperator op;

        ConstFilterLeaf(IdentifierInfo identifier, IOperator op) {
            super(identifier);
            this.op = op;
        }

        @Override
        public boolean include(RowFilter.Entry rowEntry) {
            if (this.identifier == null) {
                for (IdentifierInfo info : FilterTextParser.this.identifiers.values()) {
                    if (!this.op.apply(rowEntry.getStringValue(info.filterPosition).trim())) continue;
                    return true;
                }
                return false;
            }
            return this.op.apply(rowEntry.getValue(this.identifier.filterPosition));
        }

        public String toString() {
            return (this.identifier == null ? "" : this.identifier.name) + " " + this.op.toString();
        }
    }

    static abstract class AbstractFilterLeaf
    extends RowFilter {
        IdentifierInfo identifier;

        AbstractFilterLeaf(IdentifierInfo identifier) {
            this.identifier = identifier;
        }
    }
}

