/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert.gsm;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.lowlevel.gsm.Encoder;
import org.tritonus.lowlevel.gsm.GSMDecoder;
import org.tritonus.lowlevel.gsm.InvalidGSMFrameException;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;
import org.tritonus.share.sampled.convert.TSimpleFormatConversionProvider;

public class GSMFormatConversionProvider
extends TSimpleFormatConversionProvider {
    private static final boolean MEASURE_DECODING_TIME = false;
    private static final AudioFormat[] FORMATS1 = new AudioFormat[]{new AudioFormat(new AudioFormat.Encoding("GSM0610"), 8000.0f, -1, 1, 33, 50.0f, false), new AudioFormat(new AudioFormat.Encoding("GSM0610"), 8000.0f, -1, 1, 33, 50.0f, true), new AudioFormat(new AudioFormat.Encoding("PCM_SIGNED"), 8000.0f, 16, 1, 2, 8000.0f, false), new AudioFormat(new AudioFormat.Encoding("PCM_SIGNED"), 8000.0f, 16, 1, 2, 8000.0f, true)};
    private static final AudioFormat[] FORMATS2 = FORMATS1;
    private static final int BUFFER_SIZE = 320;
    private static final int ENCODED_GSM_FRAME_SIZE = 33;

    public GSMFormatConversionProvider() {
        super(Arrays.asList(FORMATS1), Arrays.asList(FORMATS2));
        if (TDebug.TraceAudioConverter) {
            TDebug.out("GSMFormatConversionProvider.<init>(): begin");
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("GSMFormatConversionProvider.<init>(): end");
        }
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream audioInputStream) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out("GSMFormatConversionProvider.getAudioInputStream(): begin");
            TDebug.out("GSMFormatConversionProvider.getAudioInputStream():");
            TDebug.out("checking if conversion supported");
            TDebug.out("from: " + audioInputStream.getFormat());
            TDebug.out("to: " + targetFormat);
        }
        if (this.isConversionSupported(targetFormat = this.getDefaultTargetFormat(targetFormat, audioInputStream.getFormat()), audioInputStream.getFormat())) {
            if (targetFormat.getEncoding().equals(new AudioFormat.Encoding("PCM_SIGNED"))) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("GSMFormatConversionProvider.getAudioInputStream():");
                    TDebug.out("conversion supported; trying to create DecodedGSMAudioInputStream");
                }
                return new DecodedGSMAudioInputStream(targetFormat, audioInputStream);
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("GSMFormatConversionProvider.getAudioInputStream():");
                TDebug.out("conversion supported; trying to create EncodedGSMAudioInputStream");
            }
            return new EncodedGSMAudioInputStream(targetFormat, audioInputStream);
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("GSMFormatConversionProvider.getAudioInputStream():");
            TDebug.out("conversion not supported; throwing IllegalArgumentException");
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    protected AudioFormat getDefaultTargetFormat(AudioFormat targetFormat, AudioFormat sourceFormat) {
        for (AudioFormat format : this.getCollectionTargetFormats()) {
            if (!AudioFormats.matches(targetFormat, format)) continue;
            return format;
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    public static class EncodedGSMAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        private AudioInputStream m_decodedStream;
        private Encoder m_encoder;
        private byte[] m_abBuffer;
        private short[] m_asBuffer;
        private byte[] m_abFrameBuffer;

        public EncodedGSMAudioInputStream(AudioFormat outputFormat, AudioInputStream inputStream) {
            super(outputFormat, inputStream.getFrameLength() == -1L ? -1L : inputStream.getFrameLength() / 160L);
            if (TDebug.TraceAudioConverter) {
                TDebug.out("EncodedGSMAudioInputStream.<init>(): begin");
            }
            this.m_decodedStream = inputStream;
            this.m_encoder = new Encoder();
            this.m_abBuffer = new byte[320];
            this.m_asBuffer = new short[160];
            this.m_abFrameBuffer = new byte[33];
            if (TDebug.TraceAudioConverter) {
                TDebug.out("EncodedGSMAudioInputStream.<init>(): end");
            }
        }

        public void execute() {
            if (TDebug.TraceAudioConverter) {
                TDebug.out(">EncodedGSMAudioInputStream.execute(): begin");
            }
            try {
                int nRead = this.m_decodedStream.read(this.m_abBuffer);
                if (nRead != this.m_abBuffer.length) {
                    if (TDebug.TraceAudioConverter) {
                        TDebug.out("<EncodedGSMAudioInputStream.execute(): not read whole 160 sample block (" + nRead + ")");
                    }
                    this.getCircularBuffer().close();
                    return;
                }
            }
            catch (IOException e) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out(e);
                }
                this.getCircularBuffer().close();
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("<");
                }
                return;
            }
            for (int i = 0; i < 160; ++i) {
                this.m_asBuffer[i] = TConversionTool.bytesToShort16(this.m_abBuffer, i * 2, this.isBigEndian());
            }
            this.m_encoder.encode(this.m_asBuffer, this.m_abFrameBuffer);
            this.getCircularBuffer().write(this.m_abFrameBuffer);
            if (TDebug.TraceAudioConverter) {
                TDebug.out("<EncodedGSMAudioInputStream.execute(): encoded GSM frame written");
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out(">EncodedGSMAudioInputStream.execute(): end");
            }
        }

        private boolean isBigEndian() {
            return this.m_decodedStream.getFormat().isBigEndian();
        }

        public void close() throws IOException {
            super.close();
            this.m_decodedStream.close();
        }
    }

    public static class DecodedGSMAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        private DataInputStream m_encodedStream;
        private GSMDecoder m_decoder;
        private byte[] m_abFrameBuffer;
        private byte[] m_abBuffer;

        public DecodedGSMAudioInputStream(AudioFormat outputFormat, AudioInputStream inputStream) {
            super(outputFormat, inputStream.getFrameLength() == -1L ? -1L : inputStream.getFrameLength() * 160L);
            if (TDebug.TraceAudioConverter) {
                TDebug.out("DecodedGSMAudioInputStream.<init>(): begin");
            }
            this.m_encodedStream = new DataInputStream(inputStream);
            this.m_decoder = new GSMDecoder();
            this.m_abFrameBuffer = new byte[33];
            this.m_abBuffer = new byte[320];
            if (TDebug.TraceAudioConverter) {
                TDebug.out("DecodedGSMAudioInputStream.<init>(): end");
            }
        }

        public void execute() {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("DecodedGSMAudioInputStream.execute(): begin");
            }
            try {
                this.m_encodedStream.readFully(this.m_abFrameBuffer);
            }
            catch (IOException e) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out(e);
                }
                this.getCircularBuffer().close();
                return;
            }
            try {
                this.m_decoder.decode(this.m_abFrameBuffer, 0, this.m_abBuffer, 0, this.isBigEndian());
            }
            catch (InvalidGSMFrameException e) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out(e);
                }
                this.getCircularBuffer().close();
                return;
            }
            this.getCircularBuffer().write(this.m_abBuffer);
            if (TDebug.TraceAudioConverter) {
                TDebug.out("DecodedGSMAudioInputStream.execute(): decoded GSM frame written");
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("DecodedGSMAudioInputStream.execute(): end");
            }
        }

        private boolean isBigEndian() {
            return this.getFormat().isBigEndian();
        }

        public void close() throws IOException {
            super.close();
            this.m_encodedStream.close();
        }
    }
}

