/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file.gsm;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class GSMAudioFileReader
extends TAudioFileReader {
    private static final int GSM_MAGIC = 208;
    private static final int GSM_MAGIC_MASK = 240;
    private static final int MARK_LIMIT = 1;

    public GSMAudioFileReader() {
        super(1, true);
    }

    protected AudioFileFormat getAudioFileFormat(InputStream inputStream, long lFileSizeInBytes) throws UnsupportedAudioFileException, IOException {
        int b0;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("GSMAudioFileReader.getAudioFileFormat(): begin");
        }
        if ((b0 = inputStream.read()) < 0) {
            throw new EOFException();
        }
        if ((b0 & 0xF0) != 208) {
            throw new UnsupportedAudioFileException("not a GSM stream: wrong magic number");
        }
        int nByteSize = -1;
        int nFrameSize = -1;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (lFileSizeInBytes != -1L) {
            long lFrameSize = lFileSizeInBytes / 33L;
            long lDuration = lFrameSize * 20000L;
            properties.put("duration", lDuration);
            if (lFileSizeInBytes <= Integer.MAX_VALUE) {
                nByteSize = (int)lFileSizeInBytes;
                nFrameSize = (int)(lFileSizeInBytes / 33L);
            }
        }
        HashMap<String, Object> afProperties = new HashMap<String, Object>();
        afProperties.put("bitrate", 13200L);
        AudioFormat format = new AudioFormat(new AudioFormat.Encoding("GSM0610"), 8000.0f, -1, 1, 33, 50.0f, true, afProperties);
        TAudioFileFormat audioFileFormat = new TAudioFileFormat(new AudioFileFormat.Type("GSM", "gsm"), format, nFrameSize, nByteSize, properties);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("GSMAudioFileReader.getAudioFileFormat(): end");
        }
        return audioFileFormat;
    }
}

