/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.MiscellaneousStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class LockTableNode
extends MiscellaneousStatementNode {
    private TableName tableName;
    private boolean exclusiveMode;
    private long conglomerateNumber;
    private TableDescriptor lockTableDescriptor;

    LockTableNode(TableName tableName, boolean bl, ContextManager contextManager) {
        super(contextManager);
        this.tableName = tableName;
        this.exclusiveMode = bl;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    String statementToString() {
        return "LOCK TABLE";
    }

    @Override
    public void bindStatement() throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        String string = this.tableName.getSchemaName();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(string);
        if (schemaDescriptor.isSystemSchema()) {
            throw StandardException.newException((String)"42X62", (Object[])new Object[]{this.statementToString(), string});
        }
        this.lockTableDescriptor = this.getTableDescriptor(this.tableName.getTableName(), schemaDescriptor);
        if (this.lockTableDescriptor == null) {
            TableName tableName = this.resolveTableToSynonym(this.tableName);
            if (tableName == null) {
                throw StandardException.newException((String)"42X05", (Object[])new Object[]{this.tableName});
            }
            this.tableName = tableName;
            schemaDescriptor = this.getSchemaDescriptor(this.tableName.getSchemaName());
            this.lockTableDescriptor = this.getTableDescriptor(tableName.getTableName(), schemaDescriptor);
            if (this.lockTableDescriptor == null) {
                throw StandardException.newException((String)"42X05", (Object[])new Object[]{this.tableName});
            }
        }
        if (this.lockTableDescriptor.getTableType() == 3) {
            throw StandardException.newException((String)"42995", (Object[])new Object[0]);
        }
        this.conglomerateNumber = this.lockTableDescriptor.getHeapConglomerateId();
        ConglomerateDescriptor conglomerateDescriptor = this.lockTableDescriptor.getConglomerateDescriptor(this.conglomerateNumber);
        compilerContext.createDependency(this.lockTableDescriptor);
        compilerContext.createDependency(conglomerateDescriptor);
        if (this.isPrivilegeCollectionRequired()) {
            compilerContext.pushCurrentPrivType(0);
            compilerContext.addRequiredTablePriv(this.lockTableDescriptor);
            compilerContext.popCurrentPrivType();
        }
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return LockTableNode.isSessionSchema(this.lockTableDescriptor.getSchemaName());
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getLockTableConstantAction(this.tableName.getFullTableName(), this.conglomerateNumber, this.exclusiveMode);
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.tableName != null) {
            this.tableName = (TableName)this.tableName.accept(visitor);
        }
    }
}

