/*
 * Decompiled with CFR 0.152.
 */
package com.byteslooser.filters.parser.re;

import com.byteslooser.filters.artifacts.RowFilter;
import com.byteslooser.filters.parser.FilterTextParsingException;
import com.byteslooser.filters.parser.IFilterTextParser;
import com.byteslooser.filters.parser.IdentifierInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class REFilterTextParser
extends RowFilter
implements IFilterTextParser {
    private boolean ignoreCase;
    private Pattern pattern;
    private int filterPosition;
    List<IdentifierInfo> validIdentifiers;

    @Override
    public boolean include(RowFilter.Entry entry) {
        if (this.pattern == null) {
            return true;
        }
        if (this.filterPosition != -1) {
            return this.pattern.matcher(entry.getStringValue(this.filterPosition)).find();
        }
        for (IdentifierInfo info : this.validIdentifiers) {
            if (!this.pattern.matcher(entry.getStringValue(info.filterPosition)).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setIdentifiers(List<IdentifierInfo> validIdentifiers) {
        this.validIdentifiers = new ArrayList<IdentifierInfo>(validIdentifiers);
    }

    @Override
    public RowFilter parseText(String expression, int defaultFilterPosition) throws FilterTextParsingException {
        this.filterPosition = defaultFilterPosition;
        try {
            this.pattern = this.ignoreCase ? Pattern.compile(expression, 2) : Pattern.compile(expression);
            return this;
        }
        catch (PatternSyntaxException pse) {
            this.pattern = null;
            throw new FilterTextParsingException(pse.getLocalizedMessage(), pse.getIndex());
        }
    }

    @Override
    public void setIgnoreCase(boolean ignore) {
        this.ignoreCase = ignore;
    }
}

