/*
 * Decompiled with CFR 0.152.
 */
package com.byteslooser.filters.parser.generic;

import com.byteslooser.filters.parser.generic.IOperator;
import com.byteslooser.filters.parser.generic.IRelationalOperand;
import java.util.regex.Pattern;

public class StringWildcardOperand
implements IRelationalOperand {
    private String repr;
    private boolean ignoreCase;
    boolean equal;

    public StringWildcardOperand(String repr, boolean equal, boolean ignoreCase) {
        this.repr = repr;
        this.equal = equal;
        this.ignoreCase = ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public String toString() {
        return this.repr;
    }

    @Override
    public boolean stringBased() {
        return true;
    }

    @Override
    public boolean appliesOnType(Class<?> c) {
        return true;
    }

    @Override
    public int symbolLength() {
        return this.repr.length();
    }

    @Override
    public IOperator createOperator(final Object right) {
        if (right == null) {
            return null;
        }
        String c = this.convertWilcardExpressionToRegularExpression(right.toString());
        final Pattern pattern = this.ignoreCase ? Pattern.compile(c, 2) : Pattern.compile(c);
        return new IOperator(){

            @Override
            public boolean apply(Object left) {
                if (left == null) {
                    return !StringWildcardOperand.this.equal;
                }
                return pattern.matcher(left.toString()).matches() == StringWildcardOperand.this.equal;
            }

            public String toString() {
                return StringWildcardOperand.this.toString() + " " + right.toString();
            }
        };
    }

    private String convertWilcardExpressionToRegularExpression(String s) {
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        block6: for (char c : s.toCharArray()) {
            switch (c) {
                case '\\': {
                    if (escaped) {
                        sb.append("\\");
                    }
                    escaped = !escaped;
                    continue block6;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append('\\').append(c);
                    escaped = false;
                    continue block6;
                }
                case '*': {
                    if (escaped) {
                        sb.append("\\*");
                        escaped = false;
                        continue block6;
                    }
                    sb.append(".*");
                    continue block6;
                }
                case '?': {
                    if (escaped) {
                        sb.append("\\?");
                        escaped = false;
                        continue block6;
                    }
                    sb.append(".");
                    continue block6;
                }
                default: {
                    sb.append(c);
                    escaped = false;
                }
            }
        }
        return sb.toString();
    }
}

