/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.lowlevel.pvorbis;

import java.util.ArrayList;
import java.util.List;
import org.tritonus.lowlevel.pogg.Buffer;
import org.tritonus.lowlevel.pvorbis.VorbisConstants;
import org.tritonus.share.TDebug;

public class Comment
implements VorbisConstants {
    private String m_vendor;
    private List<String> m_comments;

    public Comment() {
        if (TDebug.TraceVorbisNative) {
            TDebug.out("Comment.<init>(): begin");
        }
        if (TDebug.TraceVorbisNative) {
            TDebug.out("Comment.<init>(): end");
        }
    }

    public void finalize() {
    }

    public void free() {
    }

    public void init() {
        this.m_vendor = null;
        this.m_comments = new ArrayList<String>();
    }

    public void addComment(String strComment) {
        this.m_comments.add(strComment);
    }

    public void addTag(String strTag, String strContents) {
        this.addComment(strTag + "=" + strContents);
    }

    public int queryCount(String strTag) {
        String strFullTag = strTag + "=";
        int nCount = 0;
        for (int i = 0; i < this.m_comments.size(); ++i) {
            if (!this.m_comments.get(i).startsWith(strFullTag)) continue;
            ++nCount;
        }
        return nCount;
    }

    public String query(String strTag, int nIndex) {
        int nCount = 0;
        for (int i = 0; i < this.m_comments.size(); ++i) {
            if (i == nIndex) {
                return this.m_comments.get(i).substring(strTag.length() + 1);
            }
            ++nCount;
        }
        return null;
    }

    public String[] getUserComments() {
        return this.m_comments.toArray(new String[this.m_comments.size()]);
    }

    public String getVendor() {
        return this.m_vendor;
    }

    public void clear() {
        this.m_comments.clear();
        this.m_vendor = null;
    }

    public int pack(Buffer buffer) {
        String strVendor = "tritonus.org pvorbis library";
        buffer.write(3, 8);
        buffer.write("vorbis");
        buffer.writeWithLength(strVendor);
        buffer.write(this.m_comments.size(), 32);
        if (this.m_comments.size() > 0) {
            for (int i = 0; i < this.m_comments.size(); ++i) {
                buffer.writeWithLength(this.m_comments.get(i));
            }
        }
        buffer.write(1, 1);
        return 0;
    }

    public int unpack(Buffer buffer) {
        String s = buffer.readString();
        if (s == null) {
            this.clear();
            return -133;
        }
        this.m_vendor = s;
        int nNumComments = buffer.read(32);
        if (nNumComments < 0) {
            this.clear();
            return -133;
        }
        for (int i = 0; i < nNumComments; ++i) {
            s = buffer.readString();
            if (s == null) {
                this.clear();
                return -133;
            }
            this.m_comments.add(s);
        }
        if (buffer.read(1) != 1) {
            this.clear();
            return -133;
        }
        return 0;
    }
}

