/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.alsa;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import org.tritonus.lowlevel.alsa.AlsaSeq;
import org.tritonus.lowlevel.alsa.AlsaSeqEvent;
import org.tritonus.lowlevel.alsa.AlsaSeqPortSubscribe;
import org.tritonus.share.TDebug;

public class AlsaMidiIn
extends Thread {
    private AlsaSeq m_alsaSeq;
    private int m_nDestPort;
    private int m_nSourceClient;
    private int m_nSourcePort;
    private AlsaMidiInListener m_listener;
    private AlsaSeqEvent m_event = new AlsaSeqEvent();
    private int[] m_anValues = new int[5];
    private long[] m_alValues = new long[1];

    public AlsaMidiIn(AlsaSeq alsaSeq, int nDestPort, int nSourceClient, int nSourcePort, AlsaMidiInListener listener) {
        this(alsaSeq, nDestPort, nSourceClient, nSourcePort, -1, false, listener);
    }

    public AlsaMidiIn(AlsaSeq alsaSeq, int nDestPort, int nSourceClient, int nSourcePort, int nTimestampingQueue, boolean bRealtime, AlsaMidiInListener listener) {
        this.m_nSourceClient = nSourceClient;
        this.m_nSourcePort = nSourcePort;
        this.m_listener = listener;
        this.m_alsaSeq = alsaSeq;
        this.m_nDestPort = nDestPort;
        if (nTimestampingQueue >= 0) {
            AlsaSeqPortSubscribe portSubscribe = new AlsaSeqPortSubscribe();
            portSubscribe.setSender(nSourceClient, nSourcePort);
            portSubscribe.setDest(this.getAlsaSeq().getClientId(), nDestPort);
            portSubscribe.setQueue(nTimestampingQueue);
            portSubscribe.setExclusive(false);
            portSubscribe.setTimeUpdate(true);
            portSubscribe.setTimeReal(bRealtime);
            this.getAlsaSeq().subscribePort(portSubscribe);
            portSubscribe.free();
        } else {
            AlsaSeqPortSubscribe portSubscribe = new AlsaSeqPortSubscribe();
            portSubscribe.setSender(nSourceClient, nSourcePort);
            portSubscribe.setDest(this.getAlsaSeq().getClientId(), nDestPort);
            this.getAlsaSeq().subscribePort(portSubscribe);
            portSubscribe.free();
        }
        this.setDaemon(true);
    }

    private AlsaSeq getAlsaSeq() {
        return this.m_alsaSeq;
    }

    public void run() {
        while (!AlsaMidiIn.interrupted()) {
            MidiEvent event = this.getEvent();
            if (TDebug.TraceAlsaMidiIn) {
                TDebug.out("AlsaMidiIn.run(): got event: " + event);
            }
            if (event != null) {
                MidiMessage message = event.getMessage();
                long lTimestamp = event.getTick();
                if (message instanceof MetaMessage) {
                    MetaMessage me = (MetaMessage)message;
                    if (TDebug.TraceAlsaMidiIn) {
                        TDebug.out("AlsaMidiIn.run(): MetaMessage.getData().length: " + me.getData().length);
                    }
                }
                this.m_listener.dequeueEvent(message, lTimestamp);
                continue;
            }
            if (!TDebug.TraceAlsaMidiIn && !TDebug.TraceAllWarnings) continue;
            TDebug.out("AlsaMidiIn.run(): received null from getEvent()");
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private MidiEvent getEvent() {
        if (TDebug.TraceAlsaMidiIn) {
            TDebug.out("AlsaMidiIn.getEvent(): before eventInput()");
        }
        while ((nReturn = this.getAlsaSeq().eventInput(this.m_event)) < 0) {
            if (TDebug.TraceAlsaMidiIn || TDebug.TraceAllWarnings) {
                TDebug.out("AlsaMidiIn.getEvent(): sleeping because got no event");
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                if (!TDebug.TraceAllExceptions) continue;
                TDebug.out(e);
            }
        }
        message /* !! */  = null;
        nType = this.m_event.getType();
        switch (nType) {
            case 6: 
            case 7: 
            case 8: {
                if (TDebug.TraceAlsaMidiIn) {
                    TDebug.out("AlsaMidiIn.getEvent(): note/aftertouch event");
                }
                this.m_event.getNote(this.m_anValues);
                shortMessage = new ShortMessage();
                nCommand = -1;
                switch (nType) {
                    case 6: {
                        nCommand = 144;
                        break;
                    }
                    case 7: {
                        nCommand = 128;
                        break;
                    }
                    case 8: {
                        nCommand = 160;
                    }
                }
                nChannel = this.m_anValues[0] & 15;
                nKey = this.m_anValues[1] & 127;
                nVelocity = this.m_anValues[2] & 127;
                try {
                    shortMessage.setMessage(nCommand, nChannel, nKey, nVelocity);
                }
                catch (InvalidMidiDataException e) {
                    if (!TDebug.TraceAlsaMidiIn && !TDebug.TraceAllExceptions) ** GOTO lbl40
                    TDebug.out(e);
                }
lbl40:
                // 3 sources

                message /* !! */  = shortMessage;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: {
                this.m_event.getControl(this.m_anValues);
                nCommand = -1;
                nChannel = this.m_anValues[0] & 15;
                nData1 = -1;
                nData2 = -1;
                switch (nType) {
                    case 10: {
                        if (TDebug.TraceAlsaMidiIn) {
                            TDebug.out("AlsaMidiIn.getEvent(): controller event");
                        }
                        nCommand = 176;
                        nData1 = this.m_anValues[1] & 127;
                        nData2 = this.m_anValues[2] & 127;
                        break;
                    }
                    case 11: {
                        if (TDebug.TraceAlsaMidiIn) {
                            TDebug.out("AlsaMidiIn.getEvent(): program change event");
                        }
                        nCommand = 192;
                        nData1 = this.m_anValues[2] & 127;
                        nData2 = 0;
                        break;
                    }
                    case 12: {
                        if (TDebug.TraceAlsaMidiIn) {
                            TDebug.out("AlsaMidiIn.getEvent(): channel pressure event");
                        }
                        nCommand = 208;
                        nData1 = this.m_anValues[2] & 127;
                        nData2 = 0;
                        break;
                    }
                    case 13: {
                        if (TDebug.TraceAlsaMidiIn) {
                            TDebug.out("AlsaMidiIn.getEvent(): pitchbend event");
                        }
                        nCommand = 224;
                        nData1 = this.m_anValues[2] & 127;
                        nData2 = this.m_anValues[2] >> 7 & 127;
                        break;
                    }
                    case 22: {
                        if (TDebug.TraceAlsaMidiIn) {
                            TDebug.out("AlsaMidiIn.getEvent(): MTC event");
                        }
                        nCommand = 241;
                        nData1 = this.m_anValues[2] & 127;
                        nData2 = 0;
                        break;
                    }
                    case 20: {
                        if (TDebug.TraceAlsaMidiIn) {
                            TDebug.out("AlsaMidiIn.getEvent(): song position event");
                        }
                        nCommand = 242;
                        nData1 = this.m_anValues[2] & 127;
                        nData2 = this.m_anValues[2] >> 7 & 127;
                        break;
                    }
                    case 21: {
                        if (TDebug.TraceAlsaMidiIn) {
                            TDebug.out("AlsaMidiIn.getEvent(): song select event");
                        }
                        nCommand = 243;
                        nData1 = this.m_anValues[2] & 127;
                        nData2 = 0;
                    }
                }
                shortMessage = new ShortMessage();
                try {
                    shortMessage.setMessage(nCommand, nChannel, nData1, nData2);
                }
                catch (InvalidMidiDataException e) {
                    if (!TDebug.TraceAlsaMidiIn && !TDebug.TraceAllExceptions) ** GOTO lbl104
                    TDebug.out(e);
                }
lbl104:
                // 3 sources

                message /* !! */  = shortMessage;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 40: 
            case 41: 
            case 42: {
                nStatus = -1;
                switch (nType) {
                    case 40: {
                        nStatus = 246;
                        break;
                    }
                    case 36: {
                        if (TDebug.TraceAlsaMidiIn) {
                            TDebug.out("AlsaMidiIn.getEvent(): clock event");
                        }
                        nStatus = 248;
                        break;
                    }
                    case 30: {
                        nStatus = 250;
                        break;
                    }
                    case 31: {
                        nStatus = 251;
                        break;
                    }
                    case 32: {
                        nStatus = 252;
                        break;
                    }
                    case 42: {
                        nStatus = 254;
                        break;
                    }
                    case 41: {
                        nStatus = 255;
                    }
                }
                shortMessage = new ShortMessage();
                try {
                    shortMessage.setMessage(nStatus);
                }
                catch (InvalidMidiDataException e) {
                    if (!TDebug.TraceAlsaMidiIn && !TDebug.TraceAllExceptions) ** GOTO lbl138
                    TDebug.out(e);
                }
lbl138:
                // 3 sources

                message /* !! */  = shortMessage;
                break;
            }
            case 139: {
                if (TDebug.TraceAlsaMidiIn) {
                    TDebug.out("AlsaMidiIn.getEvent(): meta event");
                }
                metaMessage = new MetaMessage();
                abTransferData = this.m_event.getVar();
                nMetaType = abTransferData[0];
                abData = new byte[abTransferData.length - 1];
                System.arraycopy(abTransferData, 1, abData, 0, abTransferData.length - 1);
                try {
                    metaMessage.setMessage(nMetaType, abData, abData.length);
                }
                catch (InvalidMidiDataException e) {
                    if (!TDebug.TraceAlsaMidiIn && !TDebug.TraceAllExceptions) ** GOTO lbl154
                    TDebug.out(e);
                }
lbl154:
                // 3 sources

                message /* !! */  = metaMessage;
                break;
            }
            case 130: {
                if (TDebug.TraceAlsaMidiIn) {
                    TDebug.out("AlsaMidiIn.getEvent(): sysex event");
                }
                sysexMessage = new SysexMessage();
                abData = this.m_event.getVar();
                try {
                    sysexMessage.setMessage(abData, abData.length);
                }
                catch (InvalidMidiDataException e) {
                    if (!TDebug.TraceAlsaMidiIn && !TDebug.TraceAllExceptions) ** GOTO lbl167
                    TDebug.out(e);
                }
lbl167:
                // 3 sources

                message /* !! */  = sysexMessage;
                break;
            }
            default: {
                if (!TDebug.TraceAlsaMidiIn && !TDebug.TraceAllWarnings) break;
                TDebug.out("AlsaMidiIn.getEvent(): unknown event");
            }
        }
        if (message /* !! */  != null) {
            lTimestamp = this.m_event.getTimestamp();
            if ((this.m_event.getFlags() & 1) == 1) {
                lTimestamp /= 1000L;
            }
            event = new MidiEvent(message /* !! */ , lTimestamp);
            return event;
        }
        return null;
    }

    public static interface AlsaMidiInListener {
        public void dequeueEvent(MidiMessage var1, long var2);
    }
}

